/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseToggleButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MintToggleButtonUI
extends BaseToggleButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new MintToggleButtonUI();
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        if (!b2.isContentAreaFilled() || b2.getParent() instanceof JMenuBar) {
            return;
        }
        if (b2.getWidth() < 32 || b2.getHeight() < 16 || !b2.isBorderPainted() || !(b2.getBorder() instanceof UIResource) || AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
            ButtonModel model = b2.getModel();
            ColorUIResource color = AbstractLookAndFeel.getTheme().getButtonBackgroundColor();
            if (model.isPressed() && model.isArmed() || model.isSelected()) {
                color = AbstractLookAndFeel.getTheme().getSelectionBackgroundColor();
            } else if (b2.isRolloverEnabled() && model.isRollover()) {
                color = AbstractLookAndFeel.getTheme().getRolloverColor();
            }
            g2.setColor(color);
            g2.fillRect(0, 0, b2.getWidth(), b2.getHeight());
            if (model.isPressed() && model.isArmed() || model.isSelected()) {
                JTattooUtilities.draw3DBorder(g2, Color.lightGray, Color.white, 0, 0, b2.getWidth(), b2.getHeight());
            } else {
                JTattooUtilities.draw3DBorder(g2, Color.white, Color.lightGray, 0, 0, b2.getWidth(), b2.getHeight());
            }
            return;
        }
        Graphics2D g2D = (Graphics2D)g2;
        int width = b2.getWidth() - 2;
        int height = b2.getHeight() - 2;
        ButtonModel model = b2.getModel();
        if (model.isPressed() && model.isArmed()) {
            ColorUIResource color = AbstractLookAndFeel.getTheme().getSelectionBackgroundColor();
            g2D.setColor(color);
            g2D.fillRoundRect(0, 0, width, height, height, height);
            g2D.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawRoundRect(0, 0, width - 1, height - 1, height, height);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            return;
        }
        if (model.isSelected()) {
            Color frameColor = b2.getParent().getBackground();
            Color[] colors = ColorHelper.createColorArr(AbstractLookAndFeel.getTheme().getBackgroundColor(), Color.white, 20);
            Shape savedClip = g2D.getClip();
            Area area = new Area(new Area(new RoundRectangle2D.Double(0.0, 0.0, width, height, height, height)));
            g2D.setClip(area);
            JTattooUtilities.fillHorGradient(g2, colors, 0, 0, width, height);
            g2D.setClip(savedClip);
            JTattooUtilities.drawRound3DBorder(g2, ColorHelper.darker(frameColor, 5.0), ColorHelper.brighter(frameColor, 80.0), 0, 0, width, height);
            JTattooUtilities.drawRound3DBorder(g2, ColorHelper.darker(frameColor, 20.0), ColorHelper.brighter(frameColor, 10.0), 1, 1, width - 2, height - 2);
            return;
        }
        Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
        if (!model.isEnabled()) {
            colors = AbstractLookAndFeel.getTheme().getDisabledColors();
        } else if (b2.isRolloverEnabled() && model.isRollover()) {
            Color[] src = AbstractLookAndFeel.getTheme().getRolloverColors();
            colors = new Color[src.length];
            System.arraycopy(src, 0, colors, 0, colors.length);
            colors[colors.length - 2] = ColorHelper.darker(colors[colors.length - 2], 15.0);
        }
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = b2.getParent().getBackground();
        g2D.setColor(ColorHelper.darker(color, 6.0));
        g2D.drawRoundRect(2, 2, width - 1, height - 1, height, height);
        g2D.setColor(ColorHelper.darker(color, 18.0));
        g2D.drawRoundRect(1, 1, width - 1, height - 1, height, height);
        int x = 0;
        int y = 0;
        int w = width;
        int h2 = height;
        for (int i2 = colors.length - 1; i2 >= 0; --i2) {
            g2D.setColor(colors[i2]);
            g2D.fillRoundRect(x, y, w, h2, h2, h2);
            --h2;
            --w;
            if ((i2 + 1) % 4 == 0) {
                ++x;
                ++y;
            }
            if (h2 == 0) break;
        }
        g2D.setColor(Color.white);
        g2D.drawRoundRect(1, 1, width - 3, height - 3, height - 2, height - 2);
        g2D.drawRoundRect(1, 1, width - 3, height - 3, height - 2, height - 2);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Graphics2D g2D = (Graphics2D)g2;
        int width = b2.getWidth();
        int height = b2.getHeight();
        if (!(!AbstractLookAndFeel.getTheme().doDrawSquareButtons() && b2.isContentAreaFilled() && b2.getBorder() instanceof UIResource && (width >= 64 && height >= 16 || b2.getText() != null && b2.getText().length() != 0))) {
            g2.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g2, 4, 3, width - 8, height - 6);
        } else {
            Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(AbstractLookAndFeel.getFocusColor());
            int d2 = height - 6;
            g2D.drawRoundRect(2, 2, width - 7, height - 7, d2, d2);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        }
    }
}

